/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.sysprofile;

import com.ibm.hsc.common.util.AuimlDataBeanAdapter;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.NodeDescriptor;
import com.ibm.ui.framework.TaskSelectionEvent;
import com.ibm.ui.framework.TaskSelectionListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;

public class PISystemProfBean
extends AuimlDataBeanAdapter
implements TaskSelectionListener {
    private String m_sSysProfName;
    private String m_sLparTree;
    private NodeDescriptor[] m_ndLparTree;
    private NodeDescriptor[] m_ndLparTreeSelection;
    private String[] m_sLpars;
    private ItemDescriptor[] m_idLpars;
    private String[] m_sProfiles;
    private ItemDescriptor[] m_idProfiles;
    private boolean m_nameModified = false;
    private boolean m_sysProfModified = false;
    private Hashtable m_treeMap = null;
    private String m_serverName = null;
    private UserTaskManager m_utm = null;
    private ArrayList m_sysProfLparList = new ArrayList();
    private ArrayList m_sysProfProfileList = new ArrayList();
    private ArrayList m_idProfileList = new ArrayList();
    private ArrayList m_idLparList = new ArrayList();
    private static final String LPAR_IMAGE = "images/D_console.t.gif";
    private static final String PROFILE_IMAGE = "images/configuration.t.gif";
    private static final String MACHINE_IMAGE = "images/hsc_managed_sys.t.gif";
    private static final String DB_STRING = "###### PISystemProfBean ######";
    private static final String DELIM = "~";
    public static final String ROW = "ROW";
    public static final String MACHINE = "MACHINE";
    public static final String LPAR_TREE = "LparTree";
    public static final String ADD_BUTTON = "AddButton";
    public static final String REMOVE_BUTTON = "RemoveButton";
    public static final String SYS_TABLE = "SysProfTable";

    public void setSysProfName(String string) throws IllegalUserDataException {
        System.err.println("*************** setSysProfName *********");
        if (this.m_sSysProfName != null && !string.equals(this.m_sSysProfName)) {
            this.m_nameModified = true;
        }
        this.m_sSysProfName = string;
    }

    public String getSysProfName() {
        return this.m_sSysProfName;
    }

    public void setLparTreeSelection(NodeDescriptor[] nodeDescriptorArray) {
        NodeDescriptor nodeDescriptor = nodeDescriptorArray[0];
        if (nodeDescriptor != null) {
            if (nodeDescriptor.isLeaf()) {
                this.m_utm.setEnabled(ADD_BUTTON, true);
            } else {
                this.m_utm.setEnabled(ADD_BUTTON, false);
            }
            this.m_utm.setEnabled(REMOVE_BUTTON, false);
            this.m_utm.setSelectedRows(SYS_TABLE, null);
        }
        this.m_ndLparTreeSelection = nodeDescriptorArray;
    }

    public NodeDescriptor[] getLparTreeSelection() {
        return this.m_ndLparTreeSelection;
    }

    public void setLparTreeTreeParent(String string) {
        this.m_sLparTree = string;
    }

    public NodeDescriptor[] getLparTreeChildren() {
        return this.getTreeChildren(this.m_sLparTree);
    }

    public void setLparsSelection(String[] stringArray) throws IllegalUserDataException {
        this.m_sLpars = stringArray;
    }

    public String[] getLparsSelection() {
        return this.m_sLpars;
    }

    public void setLparsList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        if (itemDescriptorArray != null) {
            for (int i = 0; i < itemDescriptorArray.length; ++i) {
                this.m_idLparList.add(itemDescriptorArray[i]);
            }
        }
        this.m_idLpars = itemDescriptorArray;
    }

    public ItemDescriptor[] getLparsList() {
        return this.m_idLparList.toArray(new ItemDescriptor[0]);
    }

    public void setProfilesSelection(String[] stringArray) throws IllegalUserDataException {
        this.m_sProfiles = stringArray;
    }

    public String[] getProfilesSelection() {
        return this.m_sProfiles;
    }

    public void setProfilesList(ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        if (itemDescriptorArray != null) {
            for (int i = 0; i < itemDescriptorArray.length; ++i) {
                this.m_idProfileList.add(itemDescriptorArray[i]);
            }
        }
        this.m_idProfiles = itemDescriptorArray;
    }

    public ItemDescriptor[] getProfilesList() {
        return this.m_idProfileList.toArray(new ItemDescriptor[0]);
    }

    public ArrayList getSysProfLparList() {
        return this.m_sysProfLparList;
    }

    public ArrayList getSysProfProfileList() {
        return this.m_sysProfProfileList;
    }

    public boolean isNameModified() {
        return this.m_nameModified;
    }

    public boolean isSysProfModified() {
        return this.m_sysProfModified;
    }

    public void setNameModified(boolean bl) {
        this.m_nameModified = bl;
    }

    public void setUTM(UserTaskManager userTaskManager) {
        this.m_utm = userTaskManager;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.m_sSysProfName = "";
        this.m_sLparTree = "";
        this.m_ndLparTree = new NodeDescriptor[0];
        this.m_ndLparTreeSelection = new NodeDescriptor[0];
        this.m_sLpars = new String[0];
        this.m_idLpars = new ItemDescriptor[0];
        this.m_sProfiles = new String[0];
        this.m_idProfiles = new ItemDescriptor[0];
    }

    public void save() {
    }

    public void setServerName(String string) {
        this.m_serverName = string;
    }

    public void setTreeMap(Hashtable hashtable) {
        this.m_treeMap = hashtable;
    }

    private NodeDescriptor[] getTreeChildren(String string) {
        if (string == null) {
            NodeDescriptor nodeDescriptor = new NodeDescriptor(MACHINE, this.m_serverName, MACHINE_IMAGE, MACHINE_IMAGE);
            nodeDescriptor.setLeaf(false);
            nodeDescriptor.setExpandRequested(true);
            return new NodeDescriptor[]{nodeDescriptor};
        }
        if (string.equals(MACHINE)) {
            return this.getPartitionNodes();
        }
        return this.getProfileNodes(string);
    }

    private NodeDescriptor createProfileNode(String string, String string2) {
        return null;
    }

    private NodeDescriptor[] getProfileNodes(String string) {
        String[] stringArray = null;
        NodeDescriptor[] nodeDescriptorArray = new NodeDescriptor[]{};
        stringArray = (String[])this.m_treeMap.get(string);
        if (stringArray != null) {
            nodeDescriptorArray = new NodeDescriptor[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                NodeDescriptor nodeDescriptor = new NodeDescriptor(stringArray[i] + DELIM + string, stringArray[i], PROFILE_IMAGE, PROFILE_IMAGE);
                nodeDescriptor.setLeaf(true);
                nodeDescriptor.setUserObject((Object)string);
                nodeDescriptorArray[i] = nodeDescriptor;
            }
        }
        return nodeDescriptorArray;
    }

    private NodeDescriptor[] getPartitionNodes() {
        Set set = this.m_treeMap.keySet();
        Object[] objectArray = set.toArray(new String[0]);
        Arrays.sort(objectArray);
        ArrayList<NodeDescriptor> arrayList = new ArrayList<NodeDescriptor>();
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                NodeDescriptor nodeDescriptor = new NodeDescriptor((String)object, (String)object, LPAR_IMAGE, LPAR_IMAGE);
                nodeDescriptor.setLeaf(false);
                arrayList.add(nodeDescriptor);
            }
        }
        if (IDebug.enabled()) {
            System.err.println("###### PISystemProfBean ###### getPartitionNodes()>>>>");
            System.err.println("Partitions returned......");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                System.err.println((NodeDescriptor)iterator.next());
                System.err.println("#");
            }
        }
        return arrayList.toArray(new NodeDescriptor[0]);
    }

    public void addLparToList(String string, String string2) {
        ItemDescriptor itemDescriptor = new ItemDescriptor(string + ROW, string);
        itemDescriptor.setUserObject((Object)string2);
        ItemDescriptor itemDescriptor2 = new ItemDescriptor(string2 + string + ROW, string2);
        this.m_idLparList.add(itemDescriptor);
        this.m_idProfileList.add(itemDescriptor2);
        this.m_sysProfLparList.add(string);
        this.m_sysProfProfileList.add(string2);
        if (!this.m_sysProfModified) {
            this.m_sysProfModified = true;
        }
        this.debug();
        try {
            final UserTaskManager userTaskManager = this.m_utm;
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    userTaskManager.refreshElement(PISystemProfBean.SYS_TABLE);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public boolean tableContains(String string) {
        return this.m_sysProfLparList.contains(string);
    }

    public void removeRows() {
        UserTaskManager userTaskManager;
        int[] nArray = this.m_utm.getSelectedRows(SYS_TABLE);
        if (IDebug.enabled()) {
            System.err.println("###### PISystemProfBean ###### removeRows()<<<<<");
            this.debug();
        }
        if (nArray != null && nArray.length > 0) {
            ItemDescriptor[] itemDescriptorArray = this.m_idLparList.toArray(new ItemDescriptor[0]);
            ItemDescriptor[] itemDescriptorArray2 = this.m_idProfileList.toArray(new ItemDescriptor[0]);
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                userTaskManager = itemDescriptorArray[n];
                int n2 = this.m_sysProfLparList.indexOf(userTaskManager.getTitle());
                this.m_sysProfLparList.remove(n2);
                this.m_sysProfProfileList.remove(n2);
                int n3 = this.m_idLparList.indexOf(userTaskManager);
                this.m_idLparList.remove(n3);
                userTaskManager = itemDescriptorArray2[n];
                n3 = this.m_idProfileList.indexOf(userTaskManager);
                this.m_idProfileList.remove(n3);
            }
            if (!this.m_sysProfModified) {
                this.m_sysProfModified = true;
            }
        }
        if (IDebug.enabled()) {
            System.err.println("###### PISystemProfBean ###### removeRows()>>>>>>>");
            this.debug();
        }
        try {
            userTaskManager = this.m_utm;
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    userTaskManager.refreshElement(PISystemProfBean.SYS_TABLE);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void debug() {
        if (IDebug.enabled()) {
            System.err.println("###### PISystemProfBean ############# DEBUG ########");
            Iterator iterator = this.m_idLparList.iterator();
            Iterator iterator2 = this.m_idProfileList.iterator();
            System.err.println(" Lpar list size : " + this.m_idLparList.size());
            System.err.println(" Profile list size : " + this.m_idProfileList.size());
            if (this.m_idLparList.size() != this.m_idProfileList.size()) {
                System.err.println(" Sizes do not match..... ");
            }
            System.err.println(" Lpar/Profile List : ");
            while (iterator.hasNext() && iterator2.hasNext()) {
                System.err.println(((ItemDescriptor)iterator.next()).getTitle() + "/" + ((ItemDescriptor)iterator2.next()).getTitle());
            }
            System.err.println("sys prof Lpar num: " + this.m_sysProfLparList.size());
            System.err.println("sys prof Profile num: " + this.m_sysProfProfileList.size());
            iterator = this.m_sysProfLparList.iterator();
            iterator2 = this.m_sysProfProfileList.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                System.err.println(iterator.next() + "/" + iterator2.next());
            }
            System.err.println("########### DONE DEBUG ##########\n\n");
        }
    }

    public void selectionChanged(TaskSelectionEvent taskSelectionEvent) {
        if (SYS_TABLE.equals(taskSelectionEvent.getElementName())) {
            this.m_utm.setEnabled(REMOVE_BUTTON, true);
            this.m_utm.setEnabled(ADD_BUTTON, false);
            NodeDescriptor[] nodeDescriptorArray = this.getLparTreeSelection();
            if (nodeDescriptorArray != null && nodeDescriptorArray.length != 0) {
                if (IDebug.enabled()) {
                    System.err.println("Tree Node Selection Summary: ");
                    System.err.println("Nodes.length == " + nodeDescriptorArray.length);
                    System.err.println("Items : ");
                    for (int i = 0; i < nodeDescriptorArray.length; ++i) {
                        System.err.println(nodeDescriptorArray[i]);
                    }
                }
                this.m_utm.setSelected(nodeDescriptorArray[0].getName(), false);
            }
        }
    }
}

